//----------------------------------------------------------------------------//
//- CawMain.pas --------------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Diese Unit ist fr die Anzeige des Hauptfensters verantwortlich            //
//----------------------------------------------------------------------------//

unit CawMain;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, Menus, ActnList, StdCtrls, CaoPersonenListe,
  Buttons, ImgList, jpeg, CaoArtikelListe, CaoDatenBank, CaoBoersenInfo,
  CaoListeVonArtikelListen, CaoFormat, CapEtikettenReport, CapSteuerCodes;

//------------------------------------------------------------------------------

type
  TCaWinMain = class(TForm)
    m_StbStatus                 : TStatusBar;
    m_TimZeit                   : TTimer;
    m_MmuWinMain                : TMainMenu;
    m_MnuDatei                  : TMenuItem;
    m_MnuAdministrator          : TMenuItem;
    m_MnuLogin                  : TMenuItem;
    m_AclWinMain                : TActionList;
    m_MnuBeenden                : TMenuItem;
    m_LivArtikelliste           : TListView;
    m_ActStartBoerse            : TAction;
    m_MnuArtikel                : TMenuItem;
    m_MnuAnbieter               : TMenuItem;
    m_ActAnbieterUebersicht     : TAction;
    m_MnuUebersicht             : TMenuItem;
    m_PanFUebersicht            : TPanel;
    m_ActQuittungDrucken        : TAction;
    m_ActAnbieterNeu            : TAction;
    m_ActArtikelUebersicht      : TAction;
    m_MnuArtikelUebersicht      : TMenuItem;
    m_MnuAnbieterErfassen       : TMenuItem;
    m_ActPasswortAendern        : TAction;
    m_MnuPasswortAendern        : TMenuItem;
    m_ActEndBoerse              : TAction;
    m_LivTotal                  : TListView;
    m_MnuBoerseBeenden          : TMenuItem;
    m_BtnQuittung               : TBitBtn;
    m_BtnAnbieterErfassen       : TBitBtn;
    m_BtnArtikel                : TBitBtn;
    m_BtnBoerseStart            : TBitBtn;
    m_ImlIcons                  : TImageList;
    m_ImgBackGround             : TImage;
    m_TimEingabe                : TTimer;
    m_ActEinstellungen          : TAction;
    m_MnuEinstellungen          : TMenuItem;
    m_BtnBoerseStop             : TBitBtn;
    m_PanBoersenTitel           : TPanel;
    m_LblBoersenTitel           : TLabel;
    m_BtnVerkaufAbschliessen    : TBitBtn;
    m_ActVerkaufAbschliessen    : TAction;
    m_MnuHilfe                  : TMenuItem;
    m_MnuInfo                   : TMenuItem;

    //--------------------------------------------------------------------------

    procedure TimZeitTimer                  (Sender: TObject);
    procedure FormShow                      (Sender: TObject);
    procedure FormCloseQuery                (Sender: TObject;
                                             var CanClose: Boolean);
    procedure FormKeyPress                  (Sender: TObject;
                                             var Key: Char);
    procedure ActAnbieterUebersichtExecute  (Sender: TObject);
    procedure FormKeyDown                   (Sender: TObject;
                                             var Key: Word; Shift: TShiftState);
    procedure ActQuittungDruckenExecute     (Sender: TObject);
    procedure ActAnbieterNeuExecute         (Sender: TObject);
    procedure ActArtikelUebersichtExecute   (Sender: TObject);
    procedure ActPasswortAendernExecute     (Sender: TObject);
    procedure ActStartBoerseExecute         (Sender: TObject);
    procedure ActEndBoerseExecute           (Sender: TObject);
    procedure FormCreate                    (Sender: TObject);
    procedure FormDestroy                   (Sender: TObject);
    procedure TimEingabeTimer               (Sender: TObject);
    procedure ActEinstellungenExecute       (Sender: TObject);
    procedure BtnBoerseStartClick           (Sender: TObject);
    procedure BtnBoerseStopClick            (Sender: TObject);
    procedure BtnArtikelClick               (Sender: TObject);
    procedure BtnAnbieterErfassenClick      (Sender: TObject);
    procedure BtnQuittungClick              (Sender: TObject);
    procedure ActVerkaufAbschliessenExecute (Sender: TObject);
    procedure MnuInfoClick                  (Sender: TObject);

  //----------------------------------------------------------------------------

  private
    m_obFormat       : TCaoFormat;
    m_sSaveKey       : string;

    //--------------------------------------------------------------------------

    procedure PrvSetDateTimeInStatusBar;
    procedure PrvSetStatusBar(iStatus: Integer); 

  //----------------------------------------------------------------------------

  public
    procedure InitArtikelList  (fVerkaufsAbschluss: Boolean);
    procedure SetBoersenStatus (iStatus           : Integer);
    procedure SetButtonFocus;

  //----------------------------------------------------------------------------

  end; // TCaWinMain

//------------------------------------------------------------------------------

var
  CaWinMain: TCaWinMain;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CamConst, CadAdministratorLogin, CadAnbieter, CadArtikel, CamTypes,
  CadArtikelCodeAnzeige, CadAnbieterUebersicht, CadBoersenStart,
  CadArtikelUebersicht, CadPasswortAendern, CadSchlussabrechnung,
  CadEinstellungen, CaoController, CaoRegistry, CadAbout;

//------------------------------------------------------------------------------

procedure TCaWinMain.PrvSetDateTimeInStatusBar;
(*
  Fllt Datum und Zeit in die Statusbar ab
*)
begin
  // Aktuelles Datum und Zeit in der Statusbar anzeigen
  m_StbStatus.Panels[c_iStatusPanelDateTime].Text := DateToStr(Now) + ' / ' +
                                                     TimeToStr(Now);    
end; // TCaWinMain.PrvSetDateTimeInStatusBar

//------------------------------------------------------------------------------

procedure TCaWinMain.TimZeitTimer(Sender: TObject);
begin
  // Bei jedem Timer-Event wird das Datum und die Zeit in der Statusliste
  // aktualisiert
  PrvSetDateTimeInStatusBar;
end; // TCaWinMain.TimZeitTimer

//------------------------------------------------------------------------------

procedure TCaWinMain.FormShow(Sender: TObject);
begin
  m_LivArtikelliste.Height := m_LivTotal.Top;
  g_obController.SetStatusZeilen;
end; // TCaWinMain.FormShow

//------------------------------------------------------------------------------

procedure TCaWinMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
(*
  Das Close-Ereignis des Formulars abfangen
*)
begin
  // Den Dialog erst schliessen, wenn die Meldung mit ja beantwortet wurde
  CanClose := MessageDlg(c_sMeldungVerlassen, mtConfirmation, [mbYes, mbNo], 0) = mrYes;
  if CanClose then begin
    CanClose := g_obController.ProgrammBeenden;
  end; // if
end; // TCaWinMain.FormCloseQuery

//------------------------------------------------------------------------------

procedure TCaWinMain.PrvSetStatusBar(iStatus: Integer);
(*
  Den Status in der Statusbar setzen (Bereit...)
*)
var
  sStatusText: string;
begin
  case iStatus of
    c_iStatusBereit      : sStatusText := c_sStatusBereit;
    c_iStatusVerkauf     : sStatusText := c_sStatusVerkauf;
    c_iStatusKeineBoerse : sStatusText := c_sStatusKeineBoerse;
  end; // case
  m_StbStatus.Panels[c_iStatusPanelStatus].Text := sStatusText;
end; // TCaWinMain.PrvSetStatuBar

//------------------------------------------------------------------------------

procedure TCaWinMain.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key <> '9') and (m_sSaveKey = '') then begin
    g_obController.ArtikelVerkaufen(Key);
  end // if
  else begin
    if (Key in c_stCharZahlen) then begin
      m_sSaveKey := m_sSaveKey + Key;
    end; // if
    // Alle Artikelcodes oberhalb von 900000 sind als Steuerungs-Codes
    // reserviert
    if StrToInt(m_sSaveKey) > 900000 then begin
      m_TimEingabe.Enabled := True;
      case StrToInt(m_sSaveKey) of
        c_iOrderVerkaufBeenden :
          begin
            m_ActVerkaufAbschliessen.Execute;
          end; // case c_iOrderVerkaufBeenden
        c_iOrderQuittungDrucken:
          begin
            ActQuittungDruckenExecute(Sender);
          end; // case c_iOrderQuittungDrucken
        c_iOrderAnbieterErfassen:
          begin
            ActAnbieterNeuExecute(Sender); 
          end; // case c_iOrderAnbieterErfassen
        c_iOrderArtikelErfassen:
          begin 
            ActArtikelUebersichtExecute(Sender);
          end; // case c_iOrderArtikelErfassen
      end; // case
      m_sSaveKey := '';
    end; // if
  end; // else
end; // TCaWinMain.FormKeyPress

//------------------------------------------------------------------------------

procedure TCaWinMain.ActAnbieterUebersichtExecute(Sender: TObject);
(*
  Action zum Anzeigen der Anbieterbersicht
*)
begin
  CaDlgAnbieterUebersicht.ShowModal(c_iModusDefault, g_obController.obPersonenListe);
  SetButtonFocus;
end; // TCaWinMain.ActAnbieterUebersichtExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  // Wurde eine F-Taste gedrckt, so wird das entsprechende Ereignis ausgelst
  case Key of
    VK_F1     : ActQuittungDruckenExecute  (Sender);
    VK_F2     : ActAnbieterNeuExecute      (Sender);
    VK_F3     : ActArtikelUebersichtExecute(Sender);
    VK_F4     : ActStartBoerseExecute      (Sender);
    VK_F5     : ActEndBoerseExecute        (Sender);
    
    VK_Space  : g_obController.VerkaufAbschliessen;
    VK_Delete : g_obController.ArtikelverkaufRueckgaengig;
  end; // case
end; // TCaWinMain.FormKeyDown

//------------------------------------------------------------------------------

procedure TCaWinMain.ActQuittungDruckenExecute(Sender: TObject);
begin
  g_obController.QuittungDrucken;
  SetButtonFocus;
end; // TCaWinMain.ActQuittungDruckenExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.ActAnbieterNeuExecute(Sender: TObject);
(*
  Erfassen eines neuen Anbieters
*)
begin
  CaDlgAnbieterUebersicht.ShowModal(c_iModusNeu, g_obController.obPersonenListe);
  SetButtonFocus;
end; //  TCaWinMain.ActAnbieterNeuExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.ActArtikelUebersichtExecute(Sender: TObject);
var
  obTempPersonenListe: TCaoPersonenListe;
  obTempArtikelListe : TCaoArtikelListe;
  obBoersenInfo      : TCaoBoersenInfo;
begin
  obTempPersonenListe := g_obController.obPersonenListe;
  obTempArtikelListe  := g_obController.obArtikelListe;
  obBoersenInfo       := g_obController.obBoersenInfo;
  if obBoersenInfo.fBoerseActive then begin
    CaDlgArtikelUebersicht.ShowModal(obTempPersonenListe, obTempArtikelListe,
                                     obBoersenInfo);
  end // if
  else begin
    MessageDlg(c_sMeldungKeineArtikelAnzeige, mtError, [mbOk], 0);
  end; // else
  SetButtonFocus;
end; // TCaWinMain.ActArtikelUebersichtExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.ActPasswortAendernExecute(Sender: TObject);
(*
  ndern des Admin-Passwortes
*)
begin
  if CaDlgAdministratorLogin.ShowModal = mrOk then begin
    CaDlgPasswortAendern.ShowModal;
  end; // if
  SetButtonFocus;
end; // TCaWinMain.ActPasswortAendernExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.ActStartBoerseExecute(Sender: TObject);
(*
  Action zum Starten einer Brse
*)
begin
  g_obController.BoerseStarten;
  SetButtonFocus;
end; // TCaWinMain.ActStartBoerseExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.ActEndBoerseExecute(Sender: TObject);
(*
  Brse abschliessen
*)
begin
  g_obController.BoerseBeenden;
  SetButtonFocus;
end; // TCaWinMain.ActEndBoerseExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.FormCreate(Sender: TObject);
begin
  m_obFormat              := TCaoFormat.Create; 
  // Listviews leeren
  m_LivArtikelliste.Clear;
  m_LivTotal.Clear;
end; // TCaWinMain.FormCreate

//------------------------------------------------------------------------------

procedure TCaWinMain.FormDestroy(Sender: TObject);
begin
  m_obFormat.Free;  
end; // TCaWinMain.FormDestroy

//------------------------------------------------------------------------------



procedure TCaWinMain.InitArtikelList(fVerkaufsAbschluss: Boolean);
(*
  Fllt die Listview der gekauften Artikel mit Daten ab
*)
var
  iIndex     : Integer;
  obListItem : TListItem;
begin
  m_LivArtikelliste.Clear;
  m_LivTotal.Clear;
  // Die Listview mit den Artikeln mit Daten aus m_obVerkauf abfllen
  // Der neuste Eintrag soll zuoberst sein  
  for iIndex :=  g_obController.obVerkauf.Count -1 downto 0 do begin
    obListItem         := m_LivArtikelliste.Items.Add;
    obListItem.Caption := g_obController.obVerkauf.Items[iIndex].sBeschreibung;
    obListItem.SubItems.Add(m_obFormat.FormatCurrency
                               (g_obController.obVerkauf.Items[iIndex].dPreis));
  end; // for
  obListItem := m_LivTotal.Items.Add;
  obListItem.SubItems.Add(m_obFormat.FormatCurrency(g_obController.obVerkauf.dTotal));
  // Den Titel von m_LivTotal auf "Total" oder "Zwischentotal" setzen
  if fVerkaufsAbschluss then begin
    obListItem.Caption := c_sTotal;
  end // if
  else begin
    obListItem.Caption := c_sZwischenTotal;
  end; // else
end; // TCaWinMain.PrvInitArtikelList

//------------------------------------------------------------------------------ 

procedure TCaWinMain.TimEingabeTimer(Sender: TObject);
begin
  m_sSaveKey := '';
  m_TimEingabe.Enabled := False;
end; // TCaWinMain.TimEingabeTimer

//------------------------------------------------------------------------------

procedure TCaWinMain.ActEinstellungenExecute(Sender: TObject);
begin
  if CaDlgAdministratorLogin.ShowModal = mrOk then begin
    CaDlgEinstellungen.ShowModal;
  end; // if
  SetButtonFocus;
end; // TCaWinMain.ActEinstellungenExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.SetBoersenStatus(iStatus: Integer);
begin
  PrvSetStatusBar(iStatus);
  case iStatus of
    c_iStatusBereit      :
    begin
      m_ActAnbieterUebersicht.Enabled  := True;
      m_ActQuittungDrucken.Enabled     := True;
      m_ActAnbieterNeu.Enabled         := True;
      m_ActArtikelUebersicht.Enabled   := True;
      m_ActPasswortAendern.Enabled     := True;
      m_ActEinstellungen.Enabled       := True;
      m_BtnAnbieterErfassen.Enabled    := True;
      m_BtnBoerseStop.Enabled          := True;
      m_BtnBoerseStart.Enabled         := True;
      m_BtnArtikel.Enabled             := True;
      m_BtnQuittung.Enabled            := True;
      if g_obController <> nil then begin
        m_LblBoersenTitel.Caption      := g_obController.obBoersenInfo.sTitel;
      end; // if
    end; // case c_iStatusBereit
    c_iStatusVerkauf     :
    begin
      m_ActAnbieterUebersicht.Enabled  := False;
      m_ActQuittungDrucken.Enabled     := False;
      m_ActAnbieterNeu.Enabled         := False;
      m_ActArtikelUebersicht.Enabled   := False;
      m_ActPasswortAendern.Enabled     := False;
      m_ActEinstellungen.Enabled       := False;
      m_BtnAnbieterErfassen.Enabled    := False;
      m_BtnArtikel.Enabled             := False;
      m_BtnBoerseStop.Enabled          := False;
      m_BtnBoerseStart.Enabled         := False;
      m_BtnQuittung.Enabled            := False;
      m_ActVerkaufAbschliessen.Enabled := True;
      if g_obController <> nil then begin
        m_LblBoersenTitel.Caption      := g_obController.obBoersenInfo.sTitel;
      end; // if
    end; // case c_iStatusVerkauf
    c_iStatusKeineBoerse :
    begin
      m_ActAnbieterUebersicht.Enabled  := True;
      m_ActQuittungDrucken.Enabled     := False;
      m_ActAnbieterNeu.Enabled         := True;
      m_ActArtikelUebersicht.Enabled   := True;
      m_ActPasswortAendern.Enabled     := True;
      m_ActEinstellungen.Enabled       := True;
      m_BtnAnbieterErfassen.Enabled    := True;
      m_BtnArtikel.Enabled             := True;
      m_BtnBoerseStop.Enabled          := True;
      m_BtnBoerseStart.Enabled         := True;
      m_BtnQuittung.Enabled            := True;
      m_ActVerkaufAbschliessen.Enabled := False;
      m_LblBoersenTitel.Caption        := c_sMeldungBoerseNichtAktiv;
      m_LivArtikelliste.Clear;
      m_LivTotal.Clear;
    end; // case c_iStatusKeineBoerse
  end; // case
  SetButtonFocus;
end; // TCaWinMain.SetBoersenStatus

//------------------------------------------------------------------------------

procedure TCaWinMain.BtnBoerseStartClick(Sender: TObject);
(*
  Wird beim Drcken des "Brse starten"-Buttons aufgerufen
*)
begin
  m_ActStartBoerse.Execute;
end; // TCaWinMain.BtnBoerseStartClick

//------------------------------------------------------------------------------

procedure TCaWinMain.BtnBoerseStopClick(Sender: TObject);
(*
  Wird beim Drcken des "Brse beenden"-Buttons aufgerufen
*)
begin
  m_ActEndBoerse.Execute;
end; // TCaWinMain.BtnBoerseStopClick

//------------------------------------------------------------------------------

procedure TCaWinMain.BtnArtikelClick(Sender: TObject);
(*
  Wird beim Drcken des "Artikel"-Buttons aufgerufen
*)
begin
  m_ActArtikelUebersicht.Execute;
end; // TCaWinMain.BtnArtikelClick

//------------------------------------------------------------------------------

procedure TCaWinMain.BtnAnbieterErfassenClick(Sender: TObject);
(*
  Wird beim Drcken des "Anbieter erfassen"-Buttons aufgerufen
*)
begin
  m_ActAnbieterNeu.Execute;
end; // TCaWinMain.BtnAnbieterErfassenClick

//------------------------------------------------------------------------------

procedure TCaWinMain.BtnQuittungClick(Sender: TObject);
(*
  Wird beim Drcken des "Quittung drucken"-Buttons aufgerufen
*)
begin
  ActQuittungDruckenExecute(Sender);
end; // TCaWinMain.BtnQuittungClick

//------------------------------------------------------------------------------

procedure TCaWinMain.ActVerkaufAbschliessenExecute(Sender: TObject);
(*
  Action zum Abschliessen eines Verkaufs
*)
begin
  g_obController.VerkaufAbschliessen;
  SetButtonFocus;
end; // TCaWinMain.ActVerkaufAbschliessenExecute

//------------------------------------------------------------------------------

procedure TCaWinMain.SetButtonFocus;
(*
  Den Fokus auf den "Verkauf abschlissen"-Button setzen
*)
begin
  if m_BtnVerkaufAbschliessen.Enabled then begin
    m_BtnVerkaufAbschliessen.SetFocus;
  end; // if
end; // TCaWinMain.SetFocus

//------------------------------------------------------------------------------

procedure TCaWinMain.MnuInfoClick(Sender: TObject);
(*
  Anzeigen des Infodialogs
*)
begin
  CaDlgAbout.ShowModal;
end; // TCaWinMain.MnuInfoClick

//------------------------------------------------------------------------------

end. // CawMain
